//	SSW60a.cpp for NJQRP DDS-60 - note four changes for DDS-30 at	*#*#*#*#*#* 
//	written by Dr. Sam Green, W0PCE 
//	for the Fully Automated DDS Sweep Generator Measurement System 
/*
	This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
//	Single linear sweep of DDS Frequency 
//	with ADC measurement of input 2 from log detector and Write to text file  
//  Driver for MAXIM DAC110 serial A to D Converter with calibration procedure  
//  With +/-Vref set by LM385-1.2s to +/-1.234V volts, range is from -2.468V to +2.468V 
//	for a resolution of about 300 uV when running at 13 bit resolution plus sign   
//  timeout to prevent lock-up 

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <windows.h>

void delay (int ttime) ;
void delaym (long msecs) ;
void write40bits2d0 (int freqword, int phaseword) ;	// DDS
void cal (void) ;									// DDS
int writereaddatabits (int writeword);				// ADC 
void gotoxy (int x, int y) ;						// Cursor position

float RefClock = 180000000,	// 100000000 for 100MHz clock on DDS-30 *#*#*#*#*#*  
	  mult = 0x100000000/RefClock;  

int base	= 0x378,	// parallel port register addresses
	status	= base+1,
	control	= base+2,
	phaseword = 0x01,		// phaseword = 0x00 for DDS-30			*#*#*#*#*#* 
	startword  = 1000000*mult,	// default 1 MHz start
	endword  = 10000000*mult, 	// default 10 MHz end
	numberofsteps = 0x1000,	// default 4096 steps 
	stepcount = (endword-startword)/numberofsteps, // default increment ,
	freqword = startword,
	writeword1	= 0x8100,	// input 1 and divide clock by 4 - replace five places to change input!!
	writeword2	= 0x8110,	// input 2 and divide clock by 4
	CONVbits	= 0x0600,	// default 13 bits and 50 measurements per second  
	CSactive	= 0xbf,	    // active low so set D6 = 0 
	CSinactive	= 0xff,	    // all ones
	ClockLow	= 0xdf,	    // set D5 = 0 
	DataBitLow	= 0xef,	    // set D4 = 0 
	DataBitHi	= 0xff,	    // all ones 
	value,
	tt=0, 
	intreading, 
	sign, 
	overflow, 
	cc, 
	once = 1;

double  duration;

float floatreading;

clock_t start, now ,then, current, finish;

void main(int argc, char *argv[]) {
	system("CLS");

	if (argc < 2){ fprintf(stderr,"\nUsage: %s filename.txt [start] [end] [#steps]\n\n", argv[0]); 
					puts("Enter parameters as integer Hertz with no punctuation or units.\n");
					puts("Defaults are 1MHz, 10MHz, and 4096 steps.\n\nHit Control and C to cancel.\n\n");exit(1);}
	FILE *fp; 
	if ((fp = fopen(argv[1],"w")) == NULL) {fprintf(stderr,"Can't open %s\n", argv[1]); exit(2);}

	freqword = startword;  
								// Always Single Sweep
	if (argc>2) {startword = mult*atoi(argv[2]); }; // enter start  
	if (argc>3) {endword   = mult*atoi(argv[3]); }; // enter end 
	if (endword < startword) {puts("Enter end frequency higher than start frequency!");_exit(1);}

								//	change 60 to 30 for DDS-30  	*#*#*#*#*#*
	 if (endword>60000000*mult) exit(1); // delete to remove limits 
	 if (startword>endword) exit(1);
	stepcount = (endword-startword)/numberofsteps; 
	if (argc>4) {numberofsteps = atoi(argv[4]); 
		stepcount = (endword-startword)/numberofsteps;	// hex integer divided by integer
		if(stepcount==0) stepcount=1;					// could be less than 1, preventing sweep
		} 

	gotoxy(1,3);printf("DDS-60"); // change 60 to 30 for DDS-30 	*#*#*#*#*#*
	printf("\tStart Frequency     = %10.1f Hz \n", (startword/mult));
	printf("\tEnd Frequency       = %10.1f Hz  \n", (endword/mult));
	printf("\tNumber of Steps     = %d    \n", numberofsteps);
	printf("\tCount Increment     = %d    \n", stepcount);	
	printf("\tFrequency Increment = %10.3f Hz \n", stepcount/mult);	

								// swept frequency
	start = clock();
	cal ();	
	fprintf(fp," Frequency\tdBm\n");
	
								// begin frequency step loop 
	for(freqword = startword; freqword < endword; freqword += stepcount) {
			write40bits2d0 (freqword, phaseword) ;									

								// measure ADC and write to screen and file 		
		value = writereaddatabits (writeword2 | CONVbits);	
		sign = value & 0x8000 ;
		overflow = value & 0x4000 ;
		intreading = 0xffffffff & value ; 
		if (sign == 0) intreading &= 0x000003fff; else intreading |= 0xffffc000; 
		floatreading = float (intreading * 2.4485) / 0x3fff ; 
		gotoxy(3,9);printf("frequency = %8.1f Hz\t Power =  %.2f dBm \n\n", freqword/mult, 40*(floatreading-2.1)) ;  
		fprintf(fp," %.2f\t%.2f  ", freqword/mult, 40*(floatreading-2.1));
		if (sign != overflow <<1) fprintf(fp,"\tOverflow\n"); else fprintf(fp,"\t        \n");
		fflush(fp);
}	}	

void cal (void) {											// calibration procedure
	int step1 = 0xc, step2 = 8, step3 = 4, value, tt; 
	
	value = writereaddatabits (writeword2 | CONVbits | step1);  
	while((tt=0x80&_inp(base+1)) != 0) ;	 
	value = writereaddatabits (writeword2 | CONVbits | step2);  
	while((tt=0x80&_inp(base+1)) != 0) ; 
	value = writereaddatabits (writeword2 | CONVbits | step3);  
	while((tt=0x80&_inp(base+1)) != 0) ;  
}

int writereaddatabits (int writeword) {  
int i, temp, writebyte, mask=0x10000, databit, dataword=0;
	_outp(base, CSactive & DataBitLow);			// pull CS low by writing a 0 to D6
	for(i=0; i<16; i++) {           
		writebyte = CSactive & ClockLow & DataBitLow; 
		_outp(base, writebyte);					// write clock low
		mask >>= 1 ; temp = writeword & mask ;	// setup data to write to DIN - data comes out MSB first
		if (temp==0) temp = DataBitHi; else temp = DataBitLow; 
		_outp(base, writebyte |= ~temp);
		_outp(base, writebyte|= ~ClockLow);		// write clock high 
		databit = 0x40 & _inp(base + 1) ;		// read data bit 6 from DOUT 
		if (databit != 0) {dataword |= mask;}	// build dataword one bit at a time from MSB to LSB 
		}	
	_outp(base, CSinactive & DataBitLow);		// pull CS hi 
	start = clock();
	while((tt=0x80&_inp(base+1)) != 0) {if(clock() - start > 220) break;} // in milliseconds
	return dataword; 
}

void write40bits2d0 (int freqword, int phaseword) { // with clock to d1 & freq update strobe to d2
	int freqvar, i, writebit;
	freqvar = freqword ;
	for(i=1; i<33; i++) {           
		writebit = freqvar & 1; writebit |= 0xf0;	
		_outp(base, writebit);		// write bit
		_outp(base, writebit | 2);	// writeclock high
		_outp(base, writebit);	// writeclock low 
		freqvar >>= 1 ;
	}
	freqvar = phaseword ;  // all zeroes 
	for(i=1; i<9; i++) {           
		writebit = freqvar & 1;	writebit |= 0xf0; 
		_outp(base, writebit);		// write bit
		_outp(base, writebit | 2);	// writeclock high
		_outp(base, writebit);	// writeclock low 
		freqvar >>= 1 ;
	}
	_outp(base, 0xf4);	// frequency update stobe pulse high;  
	_outp(base, 0xf0);	// frequency update stobe pulse low;  
}

void gotoxy (int x, int y){
	HANDLE hdl;
	COORD coords;
	hdl = GetStdHandle(STD_OUTPUT_HANDLE);
	coords.X=x-1;
	coords.Y=y-1;
	SetConsoleCursorPosition(hdl,coords);
}

void delay (int ttime){				// short delay in fractions of a microsecond
	int i;
	for (i=0; i<ttime; i++) ;
}
	
void delaym (long msecs) {			// long delay in milliseconds
	clock_t now = clock();			// get current time
	clock_t then = now + CLOCKS_PER_SEC * (long)msecs/1000 ;
	while (now<then) now=clock() ;
}

